using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using Kampane.Properties;

namespace Kampane
{
	public class popup : Form
	{
		private Manager m;

		private Form f;

		public static NotifyIcon trayIcon;

		private ContextMenu trayMenu;

		private int card;

		public const int WM_NCLBUTTONDOWN = 161;

		public const int HT_CAPTION = 2;

		private IContainer components;

		private Panel panel1;

		private Label label1;

		private Button button1;

		private Timer timer1;

		private Timer kampanT;

		private Label title;

		private Button button2;

		private Button button3;

		private Button button4;

		private Label body;

		public popup(Manager mp, Form f)
		{
			m = mp;
			this.f = f;
			InitializeComponent();
			trayMenu = new ContextMenu();
			trayMenu.MenuItems.Add("Nastaveni", OnLogin);
			trayMenu.MenuItems.Add("Ukončit", OnExit);
			trayIcon = new NotifyIcon();
			trayIcon.Text = "MailFeed Pošťák";
			trayIcon.Icon = new Icon(Resources.icon1, 40, 40);
			trayIcon.MouseDoubleClick += TrayIcon_MouseDoubleClick;
			trayIcon.ContextMenu = trayMenu;
			trayIcon.Visible = true;
			button2.MouseLeave += button2_MouseLeave;
			button2.MouseEnter += button2_MouseEnter;
			button3.MouseLeave += button3_MouseLeave;
			button3.MouseEnter += button3_MouseEnter;
			button4.MouseLeave += button4_MouseLeave;
			button4.MouseEnter += button4_MouseEnter;
		}

		private void TrayIcon_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			check();
			if (m.kampane.Count > 0)
			{
				Show();
			}
			else
			{
				new msgbox("Informace", "Momentálně nejsou k dispozici žádné nepřečtené zprávy.").ShowDialog();
			}
		}

		private void button2_MouseEnter(object sender, EventArgs e)
		{
			if (m.kampane.Count > 1)
			{
				button2.Cursor = Cursors.Hand;
				button2.BackgroundImage = Resources.left_hover;
			}
			else
			{
				button2.Cursor = Cursors.Arrow;
			}
		}

		private void button2_MouseLeave(object sender, EventArgs e)
		{
			button2.BackgroundImage = Resources.left;
		}

		private void button3_MouseEnter(object sender, EventArgs e)
		{
			if (m.kampane.Count > 1)
			{
				button3.Cursor = Cursors.Hand;
				button3.BackgroundImage = Resources.right_hover;
			}
			else
			{
				button3.Cursor = Cursors.Arrow;
			}
		}

		private void button3_MouseLeave(object sender, EventArgs e)
		{
			button3.BackgroundImage = Resources.right;
		}

		private void button4_MouseEnter(object sender, EventArgs e)
		{
			button4.BackgroundImage = Resources.get_hover;
		}

		private void button4_MouseLeave(object sender, EventArgs e)
		{
			button4.BackgroundImage = Resources.get;
		}

		private void OnLogin(object sender, EventArgs e)
		{
			Hide();
			f.Show();
		}

		private void OnExit(object sender, EventArgs e)
		{
			Application.ExitThread();
		}

		private void Render()
		{
			Graphics graphics = CreateGraphics();
			if (m.kampane.Count == 0)
			{
				card = 0;
				Hide();
				return;
			}
			Show();
			title.Text = m.kampane[card].meno;
			body.Text = "Získáte " + m.kampane[card].body + "Kč";
			body.Location = new Point(150 - (int)((float)body.Size.Width * (graphics.DpiX / 96f)) / 2, body.Location.Y);
		}

		private void Translate(bool isForward)
		{
			if (isForward)
			{
				if (card + 1 < m.kampane.Count)
				{
					card++;
				}
				else
				{
					card = 0;
				}
			}
			else if (card > 0)
			{
				card--;
			}
			else
			{
				card = m.kampane.Count - 1;
			}
			Render();
		}

		public void _Show()
		{
			m.kampane.Clear();
			check();
			Render();
		}

		private void popup_Load(object sender, EventArgs e)
		{
			base.Visible = false;
			PlaceLowerRight();
			button1.FlatAppearance.BorderColor = Color.FromArgb(0, 255, 255, 255);
			button2.FlatAppearance.BorderColor = Color.FromArgb(0, 255, 255, 255);
			button3.FlatAppearance.BorderColor = Color.FromArgb(0, 255, 255, 255);
			button4.FlatAppearance.BorderColor = Color.FromArgb(0, 255, 255, 255);
			timer1.Enabled = true;
			base.AutoScaleMode = AutoScaleMode.Dpi;
		}

		private void PlaceLowerRight()
		{
			Screen screen = Screen.AllScreens[0];
			Screen[] allScreens = Screen.AllScreens;
			foreach (Screen screen2 in allScreens)
			{
				if (screen2.WorkingArea.Right > screen.WorkingArea.Right)
				{
					screen = screen2;
				}
			}
			base.Left = screen.WorkingArea.Right - base.Width - 10;
			base.Top = screen.WorkingArea.Bottom - base.Height - 10;
		}

		private void timer1_Tick(object sender, EventArgs e)
		{
			Hide();
			timer1.Enabled = false;
			check();
		}

		private void button1_Click(object sender, EventArgs e)
		{
			Hide();
		}

		private void check()
		{
			if (m.Check())
			{
				Show();
				Render();
			}
		}

		private void kampanT_Tick(object sender, EventArgs e)
		{
			check();
		}

		private void button2_Click(object sender, EventArgs e)
		{
			Translate(isForward: false);
		}

		private void button3_Click(object sender, EventArgs e)
		{
			Translate(isForward: true);
		}

		private void Call()
		{
			try
			{
				Process.Start(m.URI + "campMailApi.php?id=" + m.kampane[card].id + "&uhash=" + m.hash);
				m.Remove(m.kampane[card]);
				if (card >= m.kampane.Count)
				{
					card--;
				}
				Render();
			}
			catch
			{
				card = 0;
			}
		}

		private void button4_Click(object sender, EventArgs e)
		{
			Call();
		}

		private void title_Click(object sender, EventArgs e)
		{
			Call();
		}

		private void body_Click(object sender, EventArgs e)
		{
		}

		private void popup_FormClosing(object sender, FormClosingEventArgs e)
		{
			trayIcon.Icon = null;
			trayIcon.Visible = false;
			trayIcon.Dispose();
		}

		private void panel1_Paint(object sender, PaintEventArgs e)
		{
		}

		[DllImport("user32.dll")]
		public static extern int SendMessage(IntPtr hWnd, int Msg, int wParam, int lParam);

		[DllImport("user32.dll")]
		public static extern bool ReleaseCapture();

		private void panel1_MouseDown(object sender, MouseEventArgs e)
		{
			if (e.Button == MouseButtons.Left)
			{
				ReleaseCapture();
				SendMessage(base.Handle, 161, 2, 0);
			}
		}

		private void popup_MouseClick(object sender, MouseEventArgs e)
		{
			Call();
		}

		private void panel1_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			Call();
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				components.Dispose();
			}
			base.Dispose(disposing);
		}

		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
			System.ComponentModel.ComponentResourceManager componentResourceManager = new System.ComponentModel.ComponentResourceManager(typeof(Kampane.popup));
			panel1 = new System.Windows.Forms.Panel();
			label1 = new System.Windows.Forms.Label();
			button1 = new System.Windows.Forms.Button();
			timer1 = new System.Windows.Forms.Timer(components);
			kampanT = new System.Windows.Forms.Timer(components);
			title = new System.Windows.Forms.Label();
			button2 = new System.Windows.Forms.Button();
			button3 = new System.Windows.Forms.Button();
			button4 = new System.Windows.Forms.Button();
			body = new System.Windows.Forms.Label();
			panel1.SuspendLayout();
			SuspendLayout();
			panel1.BackColor = System.Drawing.Color.FromArgb(245, 19, 63);
			panel1.BackgroundImage = Kampane.Properties.Resources.head;
			panel1.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;
			panel1.Controls.Add(label1);
			panel1.Controls.Add(button1);
			panel1.Cursor = System.Windows.Forms.Cursors.SizeAll;
			panel1.Location = new System.Drawing.Point(0, 0);
			panel1.Name = "panel1";
			panel1.Size = new System.Drawing.Size(300, 30);
			panel1.TabIndex = 0;
			panel1.Paint += new System.Windows.Forms.PaintEventHandler(panel1_Paint);
			panel1.MouseDoubleClick += new System.Windows.Forms.MouseEventHandler(panel1_MouseDoubleClick);
			panel1.MouseDown += new System.Windows.Forms.MouseEventHandler(panel1_MouseDown);
			label1.AutoSize = true;
			label1.Font = new System.Drawing.Font("Arial", 9.75f, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, 238);
			label1.ForeColor = System.Drawing.Color.White;
			label1.Location = new System.Drawing.Point(51, 7);
			label1.Name = "label1";
			label1.Size = new System.Drawing.Size(0, 16);
			label1.TabIndex = 1;
			button1.BackColor = System.Drawing.Color.FromArgb(3, 143, 56);
			button1.Cursor = System.Windows.Forms.Cursors.Hand;
			button1.FlatAppearance.BorderSize = 0;
			button1.FlatAppearance.MouseOverBackColor = System.Drawing.Color.FromArgb(7, 102, 43);
			button1.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			button1.Font = new System.Drawing.Font("Arial", 9.75f, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, 238);
			button1.ForeColor = System.Drawing.Color.White;
			button1.Location = new System.Drawing.Point(275, 0);
			button1.Name = "button1";
			button1.Size = new System.Drawing.Size(25, 30);
			button1.TabIndex = 0;
			button1.Text = "X";
			button1.UseVisualStyleBackColor = false;
			button1.Click += new System.EventHandler(button1_Click);
			timer1.Enabled = true;
			timer1.Interval = 10;
			timer1.Tick += new System.EventHandler(timer1_Tick);
			kampanT.Enabled = true;
			kampanT.Interval = 60000;
			kampanT.Tick += new System.EventHandler(kampanT_Tick);
			title.BackColor = System.Drawing.Color.Transparent;
			title.Font = new System.Drawing.Font("Arial", 9.75f, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, 238);
			title.ForeColor = System.Drawing.Color.FromArgb(116, 116, 116);
			title.Location = new System.Drawing.Point(22, 43);
			title.Name = "title";
			title.Size = new System.Drawing.Size(257, 48);
			title.TabIndex = 1;
			title.Text = "Lorem ipsum dolor sit amet";
			title.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			title.Click += new System.EventHandler(title_Click);
			button2.BackColor = System.Drawing.Color.FromArgb(178, 178, 178);
			button2.BackgroundImage = Kampane.Properties.Resources.left;
			button2.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;
			button2.Cursor = System.Windows.Forms.Cursors.Hand;
			button2.FlatAppearance.BorderSize = 0;
			button2.FlatAppearance.MouseDownBackColor = System.Drawing.Color.Transparent;
			button2.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			button2.Location = new System.Drawing.Point(0, 109);
			button2.Name = "button2";
			button2.Size = new System.Drawing.Size(78, 41);
			button2.TabIndex = 2;
			button2.UseVisualStyleBackColor = false;
			button2.Click += new System.EventHandler(button2_Click);
			button3.BackColor = System.Drawing.Color.FromArgb(178, 178, 178);
			button3.BackgroundImage = Kampane.Properties.Resources.right;
			button3.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;
			button3.Cursor = System.Windows.Forms.Cursors.Hand;
			button3.FlatAppearance.BorderSize = 0;
			button3.FlatAppearance.MouseDownBackColor = System.Drawing.Color.Transparent;
			button3.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			button3.Location = new System.Drawing.Point(222, 109);
			button3.Name = "button3";
			button3.Size = new System.Drawing.Size(78, 41);
			button3.TabIndex = 3;
			button3.UseVisualStyleBackColor = false;
			button3.Click += new System.EventHandler(button3_Click);
			button4.BackColor = System.Drawing.Color.FromArgb(245, 19, 63);
			button4.BackgroundImage = Kampane.Properties.Resources.get;
			button4.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;
			button4.Cursor = System.Windows.Forms.Cursors.Hand;
			button4.FlatAppearance.BorderSize = 0;
			button4.FlatAppearance.MouseDownBackColor = System.Drawing.Color.Transparent;
			button4.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			button4.Location = new System.Drawing.Point(79, 109);
			button4.Name = "button4";
			button4.Size = new System.Drawing.Size(142, 41);
			button4.TabIndex = 4;
			button4.UseVisualStyleBackColor = false;
			button4.Click += new System.EventHandler(button4_Click);
			body.AutoSize = true;
			body.BackColor = System.Drawing.Color.FromArgb(244, 21, 100);
			body.Font = new System.Drawing.Font("Arial", 9f, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, 238);
			body.ForeColor = System.Drawing.Color.White;
			body.Location = new System.Drawing.Point(124, 91);
			body.Name = "body";
			body.Size = new System.Drawing.Size(54, 15);
			body.TabIndex = 5;
			body.Text = "+ 0 Body";
			body.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			body.Click += new System.EventHandler(body_Click);
			base.AutoScaleDimensions = new System.Drawing.SizeF(6f, 13f);
			base.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
			base.ClientSize = new System.Drawing.Size(300, 150);
			base.Controls.Add(body);
			base.Controls.Add(button4);
			base.Controls.Add(button3);
			base.Controls.Add(button2);
			base.Controls.Add(title);
			base.Controls.Add(panel1);
			base.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
			base.Icon = (System.Drawing.Icon)componentResourceManager.GetObject("$this.Icon");
			base.Name = "popup";
			base.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
			Text = "MailFeed Pošťák";
			base.TopMost = true;
			base.FormClosing += new System.Windows.Forms.FormClosingEventHandler(popup_FormClosing);
			base.Load += new System.EventHandler(popup_Load);
			base.MouseClick += new System.Windows.Forms.MouseEventHandler(popup_MouseClick);
			panel1.ResumeLayout(false);
			panel1.PerformLayout();
			ResumeLayout(false);
			PerformLayout();
		}
	}
}
