using System;
using System.ComponentModel;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace Kampane
{
	public class msgbox : Form
	{
		private Action<string> response;

		private string url;

		public const int WM_NCLBUTTONDOWN = 161;

		public const int HT_CAPTION = 2;

		private IContainer components;

		private Panel panel1;

		private Button button2;

		private Label label1;

		private Label label2;

		private Button button1;

		private Panel panel2;

		public msgbox(string title, string text, string btnText = "", Action<string> response = null, string url = "")
		{
			InitializeComponent();
			label1.Text = title;
			label2.Text = text;
			if (btnText != "")
			{
				button1.Text = btnText;
			}
			this.response = response;
			this.url = url;
		}

		private void button2_Click(object sender, EventArgs e)
		{
			Close();
		}

		private void msgbox_Load(object sender, EventArgs e)
		{
			base.AutoScaleMode = AutoScaleMode.Dpi;
			button2.FlatAppearance.BorderColor = Color.FromArgb(0, 255, 255, 255);
		}

		private void label1_Click(object sender, EventArgs e)
		{
		}

		[DllImport("user32.dll")]
		public static extern int SendMessage(IntPtr hWnd, int Msg, int wParam, int lParam);

		[DllImport("user32.dll")]
		public static extern bool ReleaseCapture();

		private void label1_MouseDown(object sender, MouseEventArgs e)
		{
			if (e.Button == MouseButtons.Left)
			{
				ReleaseCapture();
				SendMessage(base.Handle, 161, 2, 0);
			}
		}

		private void button1_Click(object sender, EventArgs e)
		{
			if (response != null)
			{
				button1.Text = "Stahuji...";
				button1.Enabled = false;
				button2.Enabled = false;
				response(url);
			}
			Close();
		}

		private void panel2_Paint(object sender, PaintEventArgs e)
		{
		}

		private void label2_Click(object sender, EventArgs e)
		{
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				components.Dispose();
			}
			base.Dispose(disposing);
		}

		private void InitializeComponent()
		{
			System.ComponentModel.ComponentResourceManager componentResourceManager = new System.ComponentModel.ComponentResourceManager(typeof(Kampane.msgbox));
			panel1 = new System.Windows.Forms.Panel();
			button2 = new System.Windows.Forms.Button();
			label1 = new System.Windows.Forms.Label();
			label2 = new System.Windows.Forms.Label();
			button1 = new System.Windows.Forms.Button();
			panel2 = new System.Windows.Forms.Panel();
			panel1.SuspendLayout();
			panel2.SuspendLayout();
			SuspendLayout();
			panel1.BackColor = System.Drawing.Color.FromArgb(46, 204, 113);
			panel1.Controls.Add(button2);
			panel1.Controls.Add(label1);
			panel1.Location = new System.Drawing.Point(-1, 0);
			panel1.Name = "panel1";
			panel1.Size = new System.Drawing.Size(313, 31);
			panel1.TabIndex = 0;
			button2.BackColor = System.Drawing.Color.FromArgb(3, 143, 56);
			button2.Cursor = System.Windows.Forms.Cursors.Hand;
			button2.FlatAppearance.BorderSize = 0;
			button2.FlatAppearance.MouseOverBackColor = System.Drawing.Color.FromArgb(7, 102, 43);
			button2.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			button2.Font = new System.Drawing.Font("Arial", 9.75f, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, 238);
			button2.ForeColor = System.Drawing.Color.White;
			button2.Location = new System.Drawing.Point(288, 0);
			button2.Name = "button2";
			button2.Size = new System.Drawing.Size(25, 30);
			button2.TabIndex = 2;
			button2.Text = "X";
			button2.UseVisualStyleBackColor = false;
			button2.Click += new System.EventHandler(button2_Click);
			label1.BackColor = System.Drawing.Color.Transparent;
			label1.Font = new System.Drawing.Font("Arial", 12f, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, 238);
			label1.ForeColor = System.Drawing.Color.White;
			label1.Location = new System.Drawing.Point(13, 5);
			label1.Name = "label1";
			label1.Size = new System.Drawing.Size(287, 23);
			label1.TabIndex = 3;
			label1.Text = "Okno";
			label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			label1.Click += new System.EventHandler(label1_Click);
			label1.MouseDown += new System.Windows.Forms.MouseEventHandler(label1_MouseDown);
			label2.BackColor = System.Drawing.SystemColors.Control;
			label2.Font = new System.Drawing.Font("Arial", 12f, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, 238);
			label2.ForeColor = System.Drawing.Color.FromArgb(64, 64, 64);
			label2.Location = new System.Drawing.Point(12, 61);
			label2.Name = "label2";
			label2.Size = new System.Drawing.Size(287, 75);
			label2.TabIndex = 1;
			label2.Text = "Obsah okna";
			label2.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			label2.Click += new System.EventHandler(label2_Click);
			button1.BackColor = System.Drawing.Color.FromArgb(46, 204, 113);
			button1.Cursor = System.Windows.Forms.Cursors.Hand;
			button1.FlatAppearance.BorderSize = 0;
			button1.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			button1.Font = new System.Drawing.Font("Arial", 12f, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, 238);
			button1.ForeColor = System.Drawing.Color.White;
			button1.Location = new System.Drawing.Point(101, 108);
			button1.Name = "button1";
			button1.Size = new System.Drawing.Size(99, 29);
			button1.TabIndex = 2;
			button1.Text = "Rozumím";
			button1.UseVisualStyleBackColor = false;
			button1.Click += new System.EventHandler(button1_Click);
			panel2.BackColor = System.Drawing.SystemColors.Control;
			panel2.Controls.Add(button1);
			panel2.Location = new System.Drawing.Point(2, 31);
			panel2.Name = "panel2";
			panel2.Size = new System.Drawing.Size(307, 146);
			panel2.TabIndex = 3;
			panel2.Paint += new System.Windows.Forms.PaintEventHandler(panel2_Paint);
			base.AutoScaleDimensions = new System.Drawing.SizeF(6f, 13f);
			base.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
			BackColor = System.Drawing.Color.FromArgb(46, 204, 113);
			base.ClientSize = new System.Drawing.Size(311, 180);
			base.Controls.Add(label2);
			base.Controls.Add(panel1);
			base.Controls.Add(panel2);
			base.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
			base.Icon = (System.Drawing.Icon)componentResourceManager.GetObject("$this.Icon");
			base.Name = "msgbox";
			base.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			Text = "MailFeed Pošťák";
			base.Load += new System.EventHandler(msgbox_Load);
			panel1.ResumeLayout(false);
			panel2.ResumeLayout(false);
			ResumeLayout(false);
		}
	}
}
