using System;
using System.ComponentModel;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using Kampane.Properties;

namespace Kampane
{
	public class Form1 : Form
	{
		private Manager m;

		private popup p;

		public const int WM_NCLBUTTONDOWN = 161;

		public const int HT_CAPTION = 2;

		private IContainer components;

		private TextBox textBox1;

		private TextBox textBox2;

		private Button button1;

		private Panel panel1;

		private Label label1;

		private Label label2;

		private Timer timer1;

		private Panel panel2;

		private Button button2;

		private WebBrowser browser;

		private Timer timer2;

		public Form1()
		{
			InitializeComponent();
			button1.MouseLeave += button1_MouseLeave;
			button1.MouseEnter += button1_MouseEnter;
			m = new Manager();
		}

		private void Form1_Load(object sender, EventArgs e)
		{
			base.AutoScaleMode = AutoScaleMode.Dpi;
			textBox1.Text = Settings.Default.meno;
			textBox2.Text = Settings.Default.heslo;
			button2.FlatAppearance.BorderColor = Color.FromArgb(0, 255, 255, 255);
			button1.FlatAppearance.BorderColor = Color.FromArgb(0, 255, 255, 255);
			if (!m.Login(textBox1.Text, textBox2.Text))
			{
				textBox1.Text = "";
				textBox2.Text = "";
				return;
			}
			Settings.Default.meno = textBox1.Text;
			Settings.Default.heslo = textBox2.Text;
			Settings.Default.Save();
			if (p == null)
			{
				p = new popup(m, this);
			}
			p.Show();
			timer1.Enabled = true;
			Hide();
		}

		private void LogIn()
		{
			if (!m.Login(textBox1.Text, textBox2.Text))
			{
				textBox1.Text = "";
				textBox2.Text = "";
				new msgbox("Ověření selhalo", "Zadal/a jste nesprávné údaje, zkuste to prosím znovu.").ShowDialog();
				return;
			}
			Settings.Default.meno = textBox1.Text;
			Settings.Default.heslo = textBox2.Text;
			Settings.Default.Save();
			if (p == null)
			{
				p = new popup(m, this);
			}
			p._Show();
			timer1.Enabled = true;
			timer2.Enabled = true;
			Hide();
		}

		private void button1_Click(object sender, EventArgs e)
		{
			LogIn();
		}

		private void panel1_Paint(object sender, PaintEventArgs e)
		{
		}

		private void timer1_Tick(object sender, EventArgs e)
		{
			Hide();
			timer1.Enabled = false;
		}

		private void button2_Click(object sender, EventArgs e)
		{
			Application.ExitThread();
		}

		[DllImport("user32.dll")]
		public static extern int SendMessage(IntPtr hWnd, int Msg, int wParam, int lParam);

		[DllImport("user32.dll")]
		public static extern bool ReleaseCapture();

		private void panel1_MouseDown(object sender, MouseEventArgs e)
		{
			if (e.Button == MouseButtons.Left)
			{
				ReleaseCapture();
				SendMessage(base.Handle, 161, 2, 0);
			}
		}

		private void textBox1_KeyUp(object sender, KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Return)
			{
				LogIn();
			}
		}

		private void button1_MouseEnter(object sender, EventArgs e)
		{
			button1.BackgroundImage = Resources.loginform_btn_hover;
		}

		private void button1_MouseLeave(object sender, EventArgs e)
		{
			button1.BackgroundImage = Resources.loginform_btn;
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing && components != null)
			{
				components.Dispose();
			}
			base.Dispose(disposing);
		}

		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
			System.ComponentModel.ComponentResourceManager componentResourceManager = new System.ComponentModel.ComponentResourceManager(typeof(Kampane.Form1));
			textBox1 = new System.Windows.Forms.TextBox();
			textBox2 = new System.Windows.Forms.TextBox();
			button1 = new System.Windows.Forms.Button();
			panel1 = new System.Windows.Forms.Panel();
			button2 = new System.Windows.Forms.Button();
			label1 = new System.Windows.Forms.Label();
			label2 = new System.Windows.Forms.Label();
			timer1 = new System.Windows.Forms.Timer(components);
			timer2 = new System.Windows.Forms.Timer(components);
			panel2 = new System.Windows.Forms.Panel();
			browser = new System.Windows.Forms.WebBrowser();
			panel1.SuspendLayout();
			panel2.SuspendLayout();
			SuspendLayout();
			textBox1.Font = new System.Drawing.Font("Arial", 20.25f, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, 238);
			textBox1.Location = new System.Drawing.Point(36, 143);
			textBox1.Name = "textBox1";
			textBox1.Size = new System.Drawing.Size(289, 39);
			textBox1.TabIndex = 0;
			textBox1.KeyUp += new System.Windows.Forms.KeyEventHandler(textBox1_KeyUp);
			textBox2.Font = new System.Drawing.Font("Arial", 20.25f, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, 238);
			textBox2.Location = new System.Drawing.Point(36, 227);
			textBox2.Name = "textBox2";
			textBox2.Size = new System.Drawing.Size(289, 39);
			textBox2.TabIndex = 1;
			textBox2.UseSystemPasswordChar = true;
			textBox2.KeyUp += new System.Windows.Forms.KeyEventHandler(textBox1_KeyUp);
			button1.BackColor = System.Drawing.Color.White;
			button1.BackgroundImage = Kampane.Properties.Resources.loginform_btn;
			button1.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;
			button1.Cursor = System.Windows.Forms.Cursors.Hand;
			button1.FlatAppearance.BorderSize = 0;
			button1.FlatAppearance.MouseOverBackColor = System.Drawing.Color.FromArgb(255, 128, 128);
			button1.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			button1.Location = new System.Drawing.Point(31, 18);
			button1.Name = "button1";
			button1.Size = new System.Drawing.Size(298, 39);
			button1.TabIndex = 2;
			button1.UseVisualStyleBackColor = false;
			button1.Click += new System.EventHandler(button1_Click);
			panel1.BackgroundImage = Kampane.Properties.Resources.loginform;
			panel1.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;
			panel1.Controls.Add(button2);
			panel1.Location = new System.Drawing.Point(0, -1);
			panel1.Name = "panel1";
			panel1.Size = new System.Drawing.Size(360, 93);
			panel1.TabIndex = 3;
			panel1.Paint += new System.Windows.Forms.PaintEventHandler(panel1_Paint);
			panel1.MouseDown += new System.Windows.Forms.MouseEventHandler(panel1_MouseDown);
			button2.BackColor = System.Drawing.Color.FromArgb(3, 143, 56);
			button2.Cursor = System.Windows.Forms.Cursors.Hand;
			button2.FlatAppearance.BorderSize = 0;
			button2.FlatAppearance.MouseOverBackColor = System.Drawing.Color.FromArgb(7, 102, 43);
			button2.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			button2.Font = new System.Drawing.Font("Arial", 9.75f, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, 238);
			button2.ForeColor = System.Drawing.Color.White;
			button2.Location = new System.Drawing.Point(335, 0);
			button2.Name = "button2";
			button2.Size = new System.Drawing.Size(25, 30);
			button2.TabIndex = 1;
			button2.Text = "X";
			button2.UseVisualStyleBackColor = false;
			button2.Click += new System.EventHandler(button2_Click);
			label1.AutoSize = true;
			label1.Font = new System.Drawing.Font("Arial", 14.25f, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, 238);
			label1.ForeColor = System.Drawing.Color.FromArgb(96, 96, 96);
			label1.Location = new System.Drawing.Point(32, 118);
			label1.Name = "label1";
			label1.Size = new System.Drawing.Size(174, 22);
			label1.TabIndex = 4;
			label1.Text = "Přihlašovací e-mail:";
			label2.AutoSize = true;
			label2.Font = new System.Drawing.Font("Arial", 14.25f, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, 238);
			label2.ForeColor = System.Drawing.Color.FromArgb(96, 96, 96);
			label2.Location = new System.Drawing.Point(32, 202);
			label2.Name = "label2";
			label2.Size = new System.Drawing.Size(169, 22);
			label2.TabIndex = 5;
			label2.Text = "Přihlašovací heslo:";
			timer1.Tick += new System.EventHandler(timer1_Tick);
			timer2.Interval = 1000;
			timer2.Enabled = true;
			panel2.BackColor = System.Drawing.Color.FromArgb(46, 204, 113);
			panel2.Controls.Add(button1);
			panel2.Location = new System.Drawing.Point(0, 291);
			panel2.Name = "panel2";
			panel2.Size = new System.Drawing.Size(360, 72);
			panel2.TabIndex = 6;
			base.AutoScaleDimensions = new System.Drawing.SizeF(6f, 13f);
			base.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
			BackColor = System.Drawing.Color.White;
			base.ClientSize = new System.Drawing.Size(360, 362);
			base.Controls.Add(panel2);
			base.Controls.Add(label2);
			base.Controls.Add(label1);
			base.Controls.Add(panel1);
			base.Controls.Add(textBox2);
			base.Controls.Add(textBox1);
			base.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
			base.Icon = (System.Drawing.Icon)componentResourceManager.GetObject("$this.Icon");
			base.Name = "Form1";
			base.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			Text = "MailFeed Pošťák";
			base.Load += new System.EventHandler(Form1_Load);
			panel1.ResumeLayout(false);
			panel2.ResumeLayout(false);
			ResumeLayout(false);
			PerformLayout();
		}
	}
}
