using System;
using System.Collections.Generic;
using Kampane;
using Newtonsoft.Json.Linq;

namespace Clicker
{
	internal class AdsCache
	{
		public class LinkInfo
		{
			public string link = "";

			public string final = "{0}";

			public string xpath = "";
		}

		public static class ViewInfo
		{
			public static int Batch = 1;

			public static int Limiter = 10;

			public static int Cycler = 60;
		}

		public static List<LinkInfo> keys = new List<LinkInfo>();

		public static List<string> keys_regex = new List<string>();

		public static List<string> keys_console_regex = new List<string>();

		public static float WeightRecess = 1.2f;

		public static List<string> views = new List<string>();

		public static float DelayStart = 1f;

		public static float DelayAdd = 5f;

		public static int ImpFrom = 5;

		public static int ImpTo = 40;

		public static float TimerTimeout = 50f;

		public static float TimerSkip = 5f;

		public static DateTime age = new DateTime(0L);

		public static void RefreshCache()
		{
			if (!(DateTime.Now.Subtract(age).TotalMinutes > 5.0))
			{
				return;
			}
			string Data = Program.LoadString("https://web-control.eu/pFt/FpZ.php?getKeys");
			dynamic json = JObject.Parse(Data);
			Logger.LogToFile("[CACHE]", ConsoleColor.DarkCyan, "Settings loaded.. {0}{1}", Environment.NewLine, Data);
			WeightRecess = json.weirec ?? ((object)WeightRecess);
			DelayStart = json.delay.start ?? ((object)DelayStart);
			DelayAdd = json.delay.add ?? ((object)DelayAdd);
			ImpFrom = json.impression.from ?? ((object)ImpFrom);
			ImpTo = json.impression.to ?? ((object)ImpTo);
			TimerTimeout = json.timeout ?? ((object)TimerTimeout);
			TimerSkip = json.skip ?? ((object)TimerSkip);
			foreach (object item in json.keys)
			{
				List<string> data = ((JArray)(dynamic)item).ToObject<List<string>>();
				int num = int.Parse(data[2]);
				if (num == 0)
				{
					keys.Add(new LinkInfo
					{
						link = data[0],
						final = data[1]
					});
				}
				if (num == 2)
				{
					keys_regex.Add(data[0]);
				}
				if (num == 3)
				{
					keys_console_regex.Add(data[0]);
				}
			}
			foreach (object item2 in json.views)
			{
				string link = (string)(dynamic)item2;
				views.Add(link);
			}
			ViewInfo.Batch = json.batch.ToObject<int>() ?? ((object)1);
			ViewInfo.Limiter = json.limiter ?? ((object)10);
			ViewInfo.Cycler = json.cycler ?? ((object)60);
			age = DateTime.Now;
		}
	}
}
